<?xml version="1.0" encoding="UTF-8"?>
<template version="2">
	<chart title="SPE: Operation Mix" series_composition="overlay" rendering_type="line" percentage="yes" height="93">
		<series name="% Retire Rate" expression="$SPEArchitecturallyRetiredRetired / ($SPEArchitecturallyRetiredRetired + $SPEArchitecturallyRetiredNotRetired)" description="% of instructions that retire successfully (lower numbers indicate wasted work)" display="ACCUMULATE" color="120,210,136"/>
		<series name="% L1D Cache Accesses" expression="$SPELevel1DataCacheAccess / ($SPEArchitecturallyRetiredRetired + $SPEArchitecturallyRetiredNotRetired)" description="% of samples triggering L1D cache accesses" display="ACCUMULATE" color="114,159,207"/>
		<series name="% LL Cache Accesses" expression="$SPELastLevelCacheAccess / ($SPEArchitecturallyRetiredRetired + $SPEArchitecturallyRetiredNotRetired)" description="% of samples triggering LL cache accesses" display="ACCUMULATE" color="252,233,79"/>
		<series name="% Exceptions" expression="$SPEExceptionGeneratedException / ($SPEArchitecturallyRetiredRetired + $SPEArchitecturallyRetiredNotRetired)" description="% of samples triggering exceptions" display="ACCUMULATE" color="92,53,102"/>
	</chart>
	<chart title="SPE: Latency (%)" series_composition="stacked" rendering_type="bar" percentage="yes" height="77">
		<series name="% Issue" expression="$SPELatencyIssueLatency/$SPELatencyTotalLatency" description="The Percentage of Latency due to Issue of Instructions" display="AVERAGE" color="242,62,78"/>
		<series name="% Translation" expression="$SPELatencyTranslationLatency/$SPELatencyTotalLatency" description="The Percentage of Latency due to Translation" display="AVERAGE" color="252,233,79"/>
		<series name="% Execution" expression="($SPELatencyTotalLatency - ($SPELatencyIssueLatency + $SPELatencyTranslationLatency)) / $SPELatencyTotalLatency" description="The Percentage of Latency due to Execution of Instructions" display="AVERAGE" color="120,210,136"/>
	</chart>
	<chart title="SPE: Latency (Cycles, Max)" series_composition="overlay" rendering_type="line">
		<series name="Total latency" expression="$SPELatencyTotalLatency" description="Cycle count from the operation being dispatched for issue to the operation being complete. Included for all operations." display="MAXIMUM" color="114,159,207" units="cycles"/>
		<series name="Issue latency" expression="$SPELatencyIssueLatency" description="Cycle count from the operation being dispatched for issue to the operation being issued for execution. This counts any delay in waiting the operation being ready to issue. Included for all operations." display="MAXIMUM" color="239,41,41" units="cycles"/>
		<series name="Translation latency" expression="$SPELatencyTranslationLatency" description="Cycle count from a virtual address being passed to the MMU for translation to the result of the translation being available. Included for all load, store and atomic operations." display="MAXIMUM" color="252,233,79" units="cycles"/>
	</chart>
	<chart title="SPE: L1D Cache Utilisation" series_composition="stacked" rendering_type="bar" percentage="yes" height="61">
		<series name="% L1D Misses" expression="$SPELevel1DataCacheAccessMiss/$SPELevel1DataCacheAccess" description="% L1 Data Cache Accesses that Miss" display="ACCUMULATE" color="239,41,41"/>
		<series name="% L1D Hits" expression="$SPELevel1DataCacheAccessHit/$SPELevel1DataCacheAccess" description="% L1 Data Cache Accesses that Hit" display="ACCUMULATE" color="138,226,52"/>
	</chart>
	<chart title="SPE: LL Cache Utilisation" series_composition="stacked" rendering_type="bar" percentage="yes" height="61">
		<series name="% LL Misses" expression="$SPELastLevelCacheAccessMiss/$SPELastLevelCacheAccess" description="% Last Level Cache Accesses that Miss" display="ACCUMULATE" color="245,121,0"/>
		<series name="% LL Hits" expression="$SPELastLevelCacheAccessHit/$SPELastLevelCacheAccess" description="% Last Level Cache Accesses that Hit" display="ACCUMULATE" color="78,154,6"/>
	</chart>
	<chart title="SPE: L/S Data Source" series_composition="stacked" rendering_type="bar" percentage="yes" height="147">
		<series name="L1D Cache" expression="$SPEDataSourceLevel1DataCache / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="138,226,52"/>
		<series name="L2 Cache" expression="$SPEDataSourceLevel2Cache / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="78,154,6"/>
		<series name="Peer CPU" expression="$SPEDataSourcePeerCPU / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="114,159,207"/>
		<series name="Local Cluster" expression="$SPEDataSourceLocalCluster / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="52,101,164"/>
		<series name="System Cache" expression="$SPEDataSourceSystemCache / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="173,127,168"/>
		<series name="Peer Cluster" expression="$SPEDataSourcePeerCluster / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="245,121,0"/>
		<series name="Remote Cluster" expression="$SPEDataSourceRemote / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="239,41,41"/>
		<series name="DRAM" expression="$SPEDataSourceDRAM / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="164,0,0"/>
	</chart>
	<chart title="SPE: Branch Prediction" series_composition="stacked" rendering_type="bar" percentage="yes" height="61">
		<series name="% Predictions" expression="$SPEBranchPredictionPredicted / ($SPEBranchPredictionPredicted+$SPEBranchPredictionMispredicted)" description="" display="ACCUMULATE" color="120,210,136"/>
		<series name="% Mispredictions" expression="$SPEBranchPredictionMispredicted/($SPEBranchPredictionPredicted+$SPEBranchPredictionMispredicted)" description="Shows the percentage of branch instructions that were mispredicted" display="ACCUMULATE" color="245,121,0"/>
	</chart>
	<chart title="SPE: Conditional Instruction" series_composition="stacked" rendering_type="bar" percentage="yes" height="61">
		<series name="% Taken" expression="$SPEConditionalInstructionTaken / ($SPEConditionalInstructionTaken+$SPEConditionalInstructionNotTaken)" description="% of conditional branch instructions, where the conditional check passes" display="ACCUMULATE" color="138,226,52"/>
		<series name="% Not Taken" expression="$SPEConditionalInstructionNotTaken / ($SPEConditionalInstructionTaken+$SPEConditionalInstructionNotTaken)" description="" display="ACCUMULATE" color="242,62,78"/>
	</chart>
	<chart title="SPE: TLB Utilisation" series_composition="overlay" rendering_type="bar" percentage="yes" height="61">
		<series name="% No Walk" expression="$SPETLBRefillTranslationTableWalkNoWalk / $SPETLBAccess" description="% of Load/Store operations that were served from the TLB" display="ACCUMULATE" color="120,210,136"/>
		<series name="% Walk" expression="$SPETLBRefillTranslationTableWalkWalk / $SPETLBAccess" description="% of Load/Store operations that caused the TLB to perform a page table walk" display="ACCUMULATE" color="239,41,41"/>
	</chart>
	<chart title="SPE: Multi-socket Data Access" series_composition="overlay" rendering_type="bar" percentage="yes" height="61">
		<series name="% Local" expression="$SPEMultiSocketDataAccessLocalSocketAccess / ($SPEMultiSocketDataAccessLocalSocketAccess + $SPEMultiSocketDataAccessRemoteSocketAccess)" description="% of load/store operations that did not cause an access to another socket in a multi-socket system. " display="ACCUMULATE" color="120,210,136"/>
		<series name="% Remote" expression="$SPEMultiSocketDataAccessRemoteSocketAccess / ($SPEMultiSocketDataAccessLocalSocketAccess + $SPEMultiSocketDataAccessRemoteSocketAccess)" description="% of load/store operations that did caused an access to another socket in a multi-socket system. " display="ACCUMULATE" color="242,62,78"/>
	</chart>
</template>
